---
generated_at: 2026-01-20 16:10:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：13-File Hex Viewer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **2MB超ファイルのスクロールバー動作**：コード内コメントに記載あるが実機検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Examples/IO Examples/FileHexViewer/Form1.frm`（行1-258）
- E-02: `Examples/IO Examples/FileHexViewer/FileHexViewer.vbp`（行1-32）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行14）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行100-106）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名はVirtually Mapped File Hex Viewer | E-01 行6, E-03 | ○ |
| C-02 | ファイルの16進数ダンプを表示する画面 | E-03, E-04 | ○ |
| C-03 | MemoryMappedFileを使用 | E-01 行98, 135, E-04 | ○ |
| C-04 | MemoryMappedViewStreamを使用 | E-01 行99, 138, E-04 | ○ |
| C-05 | BinaryReaderを使用 | E-01 行103, 139, E-04 | ○ |
| C-06 | StringBuilderを使用 | E-01 行101-102, E-04 | ○ |
| C-07 | Ceiling関数を使用 | E-01 行119, E-04 | ○ |
| C-08 | LINES_PER_PAGE = 24 | E-01 行95 | ○ |
| C-09 | BYTES_PER_LINE = 32 | E-01 行96 | ○ |
| C-10 | mFileはMemoryMappedFile型 | E-01 行98 | ○ |
| C-11 | mStreamはMemoryMappedViewStream型 | E-01 行99 | ○ |
| C-12 | mTopLineは表示開始行 | E-01 行100, 224 | ○ |
| C-13 | mPageBuilderとmLineNumberBuilderはStringBuilder | E-01 行101-102 | ○ |
| C-14 | mReaderはBinaryReader型 | E-01 行103 | ○ |
| C-15 | CreateFromFileでMemoryMappedFile作成 | E-01 行135 | ○ |
| C-16 | CreateViewStreamでストリーム取得 | E-01 行138 | ○ |
| C-17 | NewBinaryReaderでリーダー作成（LeaveOpen:=True） | E-01 行139 | ○ |
| C-18 | DisplayPageで16進数表示を構築 | E-01 行145-202 | ○ |
| C-19 | 行番号はX8書式（8桁16進数） | E-01 行163 | ○ |
| C-20 | データはX8書式（4バイト単位） | E-01 行168 | ○ |
| C-21 | mStream.Positionで読み取り位置設定 | E-01 行153, 185 | ○ |
| C-22 | ReadInt32で4バイト読み込み | E-01 行168 | ○ |
| C-23 | CloseStreamでストリーム解放 | E-01 行216 | ○ |
| C-24 | VScroll1のMin=-32768 | E-01 行25 | ○ |
| C-25 | mTopLine計算にオフセット32768を加算 | E-01 行224 | ○ |
| C-26 | PictureBoxにCourierフォント使用 | E-01 行32-38, 51-57 | ○ |
| C-27 | CommonDialogでファイル選択 | E-01 行241-246 | ○ |
| C-28 | errTrapでキャンセル処理 | E-01 行240, 248 | ○ |
| C-29 | VScroll1_ChangeでUpdateDisplay呼び出し | E-01 行251-253 | ○ |
| C-30 | VScroll1_ScrollでUpdateDisplay呼び出し | E-01 行255-257 | ○ |
| C-31 | Form_UnloadでCloseFile呼び出し | E-01 行231-237 | ○ |
| C-32 | COMDLG32.OCXが必要 | E-02 行4 | ○ |
| C-33 | VBCorLib 3.0への参照が必要 | E-02 行3 | ○ |
| C-34 | スタートアップフォームはForm1 | E-02 行6 | ○ |
| C-35 | 2MB超ファイルでのスクロールバーオーバーフロー | E-01 行112-113（コメント） | △ |

## 4) 不足情報（Unknown / Missing）
- C-35: スクロールバーオーバーフローの実際の動作
  - 候補：実機テスト / VB6 ScrollBarコントロールの仕様書

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：ソースコードから直接確認可能な内容が大半
- 1（中リスク）：大容量ファイル（2MB超）でのスクロールバー動作に制限がある
- コメントアウトされた旧コード（BitConverter.ToLong、mFile.DeleteView等）は将来的に削除を検討

## 6) レビュアーチェックリスト（最小）
- [ ] Form1.frmの行番号が実際のソースと一致するか確認
- [ ] MemoryMappedFile関連クラスの使用方法が正確か確認
- [ ] 画面機能マッピングとの整合性確認
- [ ] 大容量ファイル（2MB超）での動作確認
